@extends('layouts.app')

@section('title', 'نتائج البحث')

@section('content')
<main dir="rtl">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>

{{-- === Hero / Slider section === --}}
<div class="swiper-container it-hero-swiper" dir="rtl">
  <div class="swiper-wrapper">

    {{-- Dynamique --}}
    @if(isset($sliders) && $sliders->count())
      @foreach($sliders as $slider)
        <div class="swiper-slide" 
             style="background-image:url('{{ asset('uploads/' . $slider->image) }}'); background-size:cover; background-position:center;">
          <div class="swiper-slide-overlay" style="background: rgba(0,0,0,0.45); padding: 80px 0;">
            <div class="container">
              <div class="row align-items-center">
                <div class="col-lg-7">
                  <h5 class="text-light mb-2" style="letter-spacing:1px;">{{ $slider->soustitre_ar }}</h5>
                  <h1 class="display-5 fw-bold text-white mb-4">{{ $slider->titre_ar }}</h1>
                  @if($slider->titre_bouton_ar && $slider->lien_bouton_ar)
                    <a href="{{ $slider->lien_bouton_ar }}" class="btn btn-danger me-2">{{ $slider->titre_bouton_ar }}</a>
                  @endif
                  @if($slider->titre_bouton2_ar && $slider->lien_bouton2_ar)
                    <a href="{{ $slider->lien_bouton2_ar }}" class="btn btn-outline-light">{{ $slider->titre_bouton2_ar }}</a>
                  @endif
                </div>

                {{-- Zone de recherche intégrée --}}
                <div class="col-lg-5 mt-4 mt-lg-0">
                  <div class="hero-search-box p-4 rounded-3" style="background: rgba(255,255,255,0.08);">
                    <h5 class="text-white mb-3">ابحث في الموقع</h5>
                    <form action="{{ route('search') }}" method="GET">
                      <div class="input-group">
                        <input type="text" name="q" value="{{ request('q') }}" 
                               class="form-control form-control-lg" 
                               placeholder="أدخل كلمة البحث..." 
                               style="background:transparent; color:#fff; border:1px solid rgba(255,255,255,0.2);">
                        <button class="btn btn-danger px-4" type="submit">بحث</button>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      @endforeach

    {{-- Statique si aucun slider --}}
    @else
      <div class="swiper-slide" 
           style="background-image:url('{{ asset('images/hero-default.jpg') }}'); background-size:cover; background-position:center;">
        <div class="swiper-slide-overlay" style="background: rgba(0,0,0,0.45); padding:80px 0;">
          <div class="container">
            <div class="row align-items-center">
              <div class="col-lg-7">
                <h1 class="display-5 fw-bold text-white mb-3">مرحبا بكم في موقعنا</h1>
                <p class="text-light mb-4">بحث سريع عن الأخبار، التتويجات، والأدلة — اكتب كلمة أو جملة للبحث.</p>
              </div>
              <div class="col-lg-5">
                <div class="hero-search-box p-4 rounded-3" style="background: rgba(255,255,255,0.08);">
                  <h5 class="text-white mb-3">ابحث في الموقع</h5>
                  <form action="{{ route('search') }}" method="GET">
                    <div class="input-group">
                      <input type="text" name="q" class="form-control form-control-lg"
                             placeholder="أدخل كلمة البحث..." 
                             style="background:transparent; color:#fff; border:1px solid rgba(255,255,255,0.2);">
                      <button class="btn btn-danger px-4" type="submit">بحث</button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    @endif
  </div>

  <div class="swiper-pagination"></div>
  <div class="swiper-button-prev"></div>
  <div class="swiper-button-next"></div>
</div>

{{-- === Résultats === --}}
<div class="container mt-5" id="results">
  {{-- (Ton code des résultats reste inchangé) --}}
  {{-- ... --}}
</div>

</main>

{{-- === JS Swiper === --}}
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const swiper = new Swiper('.it-hero-swiper', {
      loop: true,
      autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
      speed: 900,
      pagination: {
        el: '.swiper-pagination',
        clickable: true,
      },
      navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev'
      },
      effect: 'fade',
      fadeEffect: { crossFade: true },
    });
  });
</script>

@push('styles')
<style>
  /* --- HERO / SLIDER --- */
  .it-hero-swiper { height: 520px; position: relative; }
  .it-hero-swiper .swiper-slide { display:flex; align-items:center; }
  .swiper-slide-overlay { width:100%; height:100%; display:flex; align-items:center; }
  .swiper-button-prev, .swiper-button-next { color:#fff; }
  .swiper-pagination-bullet { background:#fff; opacity:.8; }
  .hero-search-box input::placeholder { color: #ddd; }
  @media (max-width: 768px) {
      .it-hero-swiper { height: 340px; }
      .display-5 { font-size: 1.8rem; }
  }

  /* --- RESULTATS --- */
  .result-card { border: 1px solid rgba(0,0,0,0.05); transition: all .2s ease; }
  .result-card:hover { transform: translateY(-6px); box-shadow: 0 12px 24px rgba(0,0,0,0.1); }
  .text-truncate-3 { display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden; }
  mark { background: #ffd54f; padding: 0 .2rem; border-radius: .15rem; color: #222; }
</style>
@endpush

@endsection
